package com.ejie.ab04b.service;

import java.util.List;

import com.ejie.ab04b.model.Tramite;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0489s00Service generated by UDA, 06-Feb-2017 12:46:17.
 * 
 * @author UDA
 */

public interface TramiteService {

	/**
	 * Inserts a single row in the Ab0489s00 table.
	 * 
	 *  ab0489s00
	 *            Ab0489s00
	 *  Ab0489s00
	 *
	 * @param ab0489s00 the ab 0489 s 00
	 * @return the tramite
	 */
	Tramite add(Tramite ab0489s00);

	/**
	 * Updates a single row in the Ab0489s00 table.
	 * 
	 *  ab0489s00
	 *            Ab0489s00
	 *  Ab0489s00
	 *
	 * @param ab0489s00 the ab 0489 s 00
	 * @return the tramite
	 */
	Tramite update(Tramite ab0489s00);

	/**
	 * Finds a single row in the Ab0489s00 table.
	 * 
	 *  ab0489s00
	 *            Ab0489s00
	 *  Ab0489s00
	 *
	 * @param ab0489s00 the ab 0489 s 00
	 * @return the tramite
	 */
	Tramite find(Tramite ab0489s00);

	/**
	 * Finds a single row in the Ab0489s00 table.
	 * 
	 *  proceedingId
	 *            String
	 *  procedureId
	 *            String
	 *  Tramite
	 *
	 * @param proceedingId the proceeding id
	 * @param procedureId the procedure id
	 * @return the tramite
	 */
	public Tramite findByProceedingIdProcedureId(String proceedingId,
			String procedureId);

	/**
	 * Deletes a single row in the Ab0489s00 table.
	 * 
	 *  ab0489s00
	 *            Ab0489s00
	 *
	 * @param ab0489s00 the ab 0489 s 00
	 */
	void remove(Tramite ab0489s00);

	/**
	 * Finds a list of rows in the Ab0489s00 table.
	 * 
	 *  ab0489s00
	 *            Ab0489s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0489s00>
	 *
	 * @param ab0489s00 the ab 0489 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<Tramite> findAll(Tramite ab0489s00, JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Ab0489s00 table using like.
	 * 
	 *  ab0489s00
	 *            Ab0489s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0489s00>
	 *
	 * @param ab0489s00 the ab 0489 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<Tramite> findAllLike(Tramite ab0489s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0489s00 table.
	 * 
	 *  filterAb0489s00
	 *            Ab0489s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0489s00>
	 *
	 * @param filterAb0489s00 the filter ab 0489 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<Tramite> filter(Tramite filterAb0489s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Ab0489s00 table.
	 * 
	 *  filterAb0489s00
	 *            Ab0489s00
	 *  searchAb0489s00
	 *            Ab0489s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0489s00>>
	 *
	 * @param filterAb0489s00 the filter ab 0489 s 00
	 * @param searchAb0489s00 the search ab 0489 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<Tramite>> search(Tramite filterAb0489s00,
			Tramite searchAb0489s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Ab0489s00 table.
	 * 
	 *  filterAb0489s00
	 *            Ab0489s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0489s00 the filter ab 0489 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	Object reorderSelection(Tramite filterAb0489s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

}
